@echo off
title Update md in C:\md
setlocal EnableDelayedExpansion

:: Define source and destination folders
set "SOURCE_FOLDER=%~dp0"
if "%SOURCE_FOLDER:~-1%"=="\" set "SOURCE_FOLDER=%SOURCE_FOLDER:~0,-1%"
set "DEST_FOLDER=C:\md"
set "ICON_PATH=C:\md\yt.ico"

:: Get Desktop path using PowerShell
for /f "delims=" %%a in ('powershell -NoProfile -Command "[Environment]::GetFolderPath('Desktop')"') do set "DESKTOP=%%a"

echo.
echo =====================================
echo            Updating md
echo =====================================

:: Check if md is installed
if not exist "%DEST_FOLDER%" (
    echo [ERROR] The application is not installed!
    echo [INFO] Folder "%DEST_FOLDER%" was not found.
    echo.
    echo Please install Media Downloader before running this update.
    pause
    exit /b 1
)

echo [INFO] Found installation at %DEST_FOLDER%.
echo [INFO] Overwriting existing files...
xcopy "%SOURCE_FOLDER%" "%DEST_FOLDER%" /e /i /y >nul

if errorlevel 1 (
    echo [ERROR] File copy failed during update!
    pause
    exit /b 1
)

echo [INFO] Files copied successfully.
echo [INFO] Updating Desktop shortcut...

powershell -NoProfile -ExecutionPolicy Bypass -Command ^
  "$ws = New-Object -ComObject WScript.Shell; $s = $ws.CreateShortcut('%DESKTOP%\md.lnk');" ^
  "$s.TargetPath = 'C:\md\md.bat'; $s.WorkingDirectory = 'C:\md';" ^
  "if (Test-Path '%ICON_PATH%') { $s.IconLocation = '%ICON_PATH%' };" ^
  "$s.WindowStyle = 1; $s.Save();"

if exist "%DESKTOP%\md.lnk" (
    echo [OK] Shortcut updated successfully.
) else (
    echo [WARN] Could not create or update shortcut.
)

echo.
echo [OK] Update completed successfully!
pause
exit
