@echo off
title Install md in C:\md
setlocal EnableDelayedExpansion

:: Set source folder (current folder)
set "SOURCE_FOLDER=%~dp0"

:: Remove trailing backslash if it exists
if "%SOURCE_FOLDER:~-1%"=="\" set "SOURCE_FOLDER=%SOURCE_FOLDER:~0,-1%"

:: Set destination folder
set "DEST_FOLDER=C:\md"

:: Set icon path
set "ICON_PATH=C:\md\yt.ico"

:: Get Desktop path using PowerShell
for /f "delims=" %%a in ('powershell -NoProfile -Command "[System.Environment]::GetFolderPath('Desktop')"') do set "DESKTOP=%%a"

echo.
echo =====================================
echo          Install md in C:\md
echo =====================================
echo.

:: Check if C:\md folder exists
if exist "%DEST_FOLDER%" (
    echo [INFO] The C:\md folder already exists.
    echo.
    echo =====================================
    echo            Available Options
    echo =====================================
    echo [1] Reinstall   - Delete and copy again
    echo [2] Update      - Overwrite existing files
    echo [3] Uninstall   - Remove everything
    echo [4] Cancel
    echo.

    :CHOICE
    set /p CHOICE="Select an option (1-4): "
    set "CHOICE=!CHOICE: =!"  :: Remove extra spaces

    if "!CHOICE!"=="1" goto reinstall
    if "!CHOICE!"=="2" goto update
    if "!CHOICE!"=="3" goto uninstall
    if "!CHOICE!"=="4" exit :: Cancel and exit

    echo.
    echo [ERROR] Invalid option! Please enter a number between 1 and 4.
    echo.
    goto CHOICE
) else (
    echo [INFO] The C:\md folder is not installed.
    echo.
    set /p CONFIRM="Do you want to install md now? (Y/N): "
    set "CONFIRM=!CONFIRM: =!"  :: Remove extra spaces

    if /i "!CONFIRM!"=="Y" goto install
    if /i "!CONFIRM!"=="N" exit  :: Cancel and exit

    echo.
    echo [ERROR] Invalid option! Please enter Y or N.
    echo.
    goto CHOICE
)

:reinstall
echo.
echo =====================================
echo           Reinstalling md
echo =====================================
echo [INFO] Deleting C:\md folder...
rmdir /s /q "%DEST_FOLDER%"
goto install

:update
echo.
echo =====================================
echo             Updating md
echo =====================================
echo [INFO] Overwriting existing files and adding new ones...

xcopy "%SOURCE_FOLDER%" "%DEST_FOLDER%" /e /i /y >nul

if %ERRORLEVEL% neq 0 (
    echo [ERROR] Update failed!
    pause
    exit
)

echo [INFO] Update completed successfully!
goto copy_shortcut

:uninstall
echo.
echo =====================================
echo          Uninstalling md
echo =====================================
echo.
echo [WARNING] This action will completely remove the application!
set /p CONFIRM_UNINSTALL="Are you sure you want to continue? (Y/N): "
set "CONFIRM_UNINSTALL=!CONFIRM_UNINSTALL: =!"  :: Remove extra spaces

if /i "!CONFIRM_UNINSTALL!"=="N" (
    echo.
    echo [INFO] Uninstallation was canceled.
    exit
)

if /i "!CONFIRM_UNINSTALL!"=="Y" (
    echo [INFO] Deleting C:\md folder...
    cd c:\
    rmdir /s /q "%DEST_FOLDER%"

    echo [INFO] Removing shortcut from Desktop...
    del "%DESKTOP%\md.lnk" /q

    echo.
    echo [INFO] Uninstallation completed successfully!
    pause
    exit
)

echo.
echo [ERROR] Invalid option! Please enter Y or N.
echo.
goto uninstall

:install
echo.
echo =====================================
echo          Installing md
echo =====================================
echo [INFO] Copying files to C:\md...

xcopy "%SOURCE_FOLDER%" "%DEST_FOLDER%" /e /i /y >nul

if %ERRORLEVEL% neq 0 (
    echo [ERROR] Failed to copy files to C:\.
    pause
    exit
)

echo [INFO] Files copied successfully!
goto copy_shortcut

:copy_shortcut
echo.
echo [INFO] Creating shortcut on Desktop...

:: Use PowerShell to create the shortcut with custom icon
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
"$ws = New-Object -ComObject WScript.Shell; $s = $ws.CreateShortcut('%DESKTOP%\md.lnk'); $s.TargetPath = 'C:\md\md.bat'; $s.WorkingDirectory = 'C:\md'; if (Test-Path '%ICON_PATH%') { $s.IconLocation = '%ICON_PATH%' }; $s.WindowStyle = 1; $s.Save();"

if exist "%DESKTOP%\md.lnk" (
    echo [INFO] Shortcut md.lnk created successfully!
) else (
    echo [ERROR] Failed to create shortcut!
)

goto finalize

:finalize
:: Confirm final installation
echo.
echo =====================================
echo       Installation Check
echo =====================================

if exist "%DEST_FOLDER%" (
    echo [INFO] The C:\md folder exists.
) else (
    echo [ERROR] The C:\md folder was NOT created correctly!
)

if exist "%DEST_FOLDER%\md.bat" (
    echo [INFO] md.bat is present in C:\md.
) else (
    echo [ERROR] md.bat is missing from C:\md!
)

if exist "%DESKTOP%\md.lnk" (
    echo [INFO] Shortcut md.lnk is on Desktop.
) else (
    echo [ERROR] Shortcut md.lnk was NOT found on Desktop!
)

if exist "%ICON_PATH%" (
    echo [INFO] Using custom icon from %ICON_PATH%.
) else (
    echo [WARNING] Custom icon %ICON_PATH% not found! Default icon will be used.
)

echo.
echo =====================================
echo       Installation Completed!
echo =====================================
echo.
echo Press any key to close...
pause
exit
